# Deployment Guide - Paul Agonda PR Portfolio

This guide will help you deploy the portfolio website to production with Vercel and complete the WordPress integration.

## Prerequisites

- Node.js 16+ installed locally
- Git repository set up (GitHub, GitLab, or Bitbucket)
- Vercel account (free tier available at vercel.com)
- WordPress instance set up and configured (see WORDPRESS_SETUP.md)

## Step 1: Prepare Your Local Environment

### 1. Clone or Download the Repository
```bash
git clone <your-repo-url>
cd pr-portfolio
```

### 2. Install Dependencies
```bash
npm install
```

### 3. Create Environment Variables
Create a `.env.local` file in the project root:

```env
# WordPress Configuration
NEXT_PUBLIC_WORDPRESS_URL=https://your-wordpress-site.com
```

Replace `https://your-wordpress-site.com` with your actual WordPress URL.

### 4. Test Locally
```bash
npm run dev
```

Visit `http://localhost:3000` and verify that:
- Pages load correctly
- Navigation works
- Portfolio items are fetching from WordPress (if content is added)
- No console errors appear

## Step 2: Push to Git Repository

### 1. Initialize Git (if not already done)
```bash
git init
git add .
git commit -m "Initial PR portfolio setup"
```

### 2. Add Remote Repository
```bash
git remote add origin <your-repo-url>
git branch -M main
git push -u origin main
```

## Step 3: Deploy to Vercel

### Option A: Using Vercel CLI (Recommended)

1. **Install Vercel CLI**
```bash
npm i -g vercel
```

2. **Deploy**
```bash
vercel
```

3. **Follow the prompts:**
   - Link to existing project or create new
   - Confirm project root
   - Override build settings? (No)
   - Confirm deployment

### Option B: Using Vercel Dashboard

1. Go to https://vercel.com/new
2. Connect your Git provider
3. Select your repository
4. Click "Import"
5. Add environment variables (see Step 4 below)
6. Click "Deploy"

## Step 4: Configure Environment Variables in Vercel

### From Vercel Dashboard:

1. Go to your project settings
2. Click "Environment Variables"
3. Add the following:
   - **Name:** `NEXT_PUBLIC_WORDPRESS_URL`
   - **Value:** Your WordPress URL (e.g., `https://your-wordpress-site.com`)
   - **Environment:** Select "Production", "Preview", and "Development"
4. Click "Save"
5. Redeploy your project for changes to take effect

## Step 5: Configure WordPress for Production

### 1. Enable CORS Headers
WordPress needs to allow requests from your Vercel domain.

Add this to your WordPress `wp-config.php`:

```php
// Allow CORS from Vercel deployment
add_filter( 'rest_allowed_cors_origins', function( $origins ) {
    $origins[] = 'https://your-vercel-domain.vercel.app';
    $origins[] = 'https://your-custom-domain.com'; // If using custom domain
    return $origins;
});
```

Or install a CORS plugin:
- Search "WP CORS" in WordPress plugin directory
- Install and activate "Allow JSON CORS" plugin

### 2. Verify REST API Access
Visit:
`https://your-wordpress-site.com/wp-json/wp/v2/posts`

You should see JSON data.

### 3. Verify from Your Deployed Site
Check browser console for any CORS or network errors when loading your deployment.

## Step 6: Connect Custom Domain (Optional)

### 1. In Vercel Dashboard:
- Go to your project
- Click "Domains"
- Click "Add"
- Enter your custom domain (e.g., `paulagonda.com`)

### 2. Configure DNS:
Follow Vercel's DNS instructions:
- Add CNAME record to your domain provider
- Point to: `cname.vercel-dns.com`

Or use Vercel's nameservers for simpler setup.

### 3. In WordPress:
Update these settings:
- WordPress Address: `https://your-custom-domain.com`
- Site Address: `https://your-custom-domain.com`

## Step 7: Post-Deployment Checklist

### Functionality Tests:
- [ ] Home page loads and displays featured portfolio items
- [ ] About page displays correctly
- [ ] Portfolio page shows all projects from WordPress
- [ ] Individual portfolio items load with content
- [ ] Blog/Articles page displays posts
- [ ] Individual articles load with full content
- [ ] Press Releases page displays releases
- [ ] Contact form renders without errors
- [ ] Navigation works across all pages
- [ ] Footer displays correctly

### Performance Tests:
- [ ] Pages load within 3 seconds
- [ ] Images optimize and load correctly
- [ ] No console errors or warnings
- [ ] SEO metadata appears in page source

### Responsiveness:
- [ ] Test on mobile (375px width)
- [ ] Test on tablet (768px width)
- [ ] Test on desktop (1920px width)
- [ ] All content is readable on small screens

### Security Checks:
- [ ] HTTPS is enabled (should be automatic on Vercel)
- [ ] No sensitive data in console
- [ ] Contact form validates input
- [ ] No hardcoded API keys visible

## Step 8: Set Up Continuous Deployment

Vercel automatically deploys when you push to your Git repository.

### To Deploy Changes:
```bash
git add .
git commit -m "Update portfolio content"
git push origin main
```

Changes will automatically deploy to your Vercel URL.

## Step 9: Monitor and Maintain

### Regular Tasks:
1. **Update WordPress Content:** Add/edit posts and portfolio items in WordPress
2. **Monitor Errors:** Check Vercel deployment logs for any issues
3. **Update Dependencies:** Monthly security updates
   ```bash
   npm update
   npm audit
   ```

### View Deployment Logs:
In Vercel Dashboard → Your Project → Deployments → Click a deployment → View Logs

## Troubleshooting

### Issue: "Cannot find module" or build errors
- Clear `.next` folder: `rm -rf .next`
- Reinstall dependencies: `npm install`
- Check `package.json` for correct versions

### Issue: WordPress content not loading
1. Verify WordPress URL in environment variables
2. Check WordPress REST API is accessible
3. Verify CORS headers are configured
4. Check browser console for network errors

### Issue: Images not showing
1. Verify image URLs are publicly accessible
2. Check image file permissions in WordPress
3. Verify WordPress is not blocking external access

### Issue: Build failing on Vercel
- Check Vercel build logs for specific error
- Ensure all required environment variables are set
- Test locally with: `npm run build`

## Updating the Website

### To Add New Portfolio Items:
1. Log into WordPress Admin
2. Go to Portfolio Items → Add New
3. Fill in title, content, featured image
4. Add custom fields (client name, challenge, results)
5. Publish

Changes appear on your site within seconds (ISR cache revalidation).

### To Add New Blog Posts:
1. Log into WordPress Admin
2. Go to Posts → Add New
3. Fill in title, content, featured image
4. Publish

### To Modify Site Content/Copy:
For hardcoded content (not from WordPress):
1. Edit relevant page file in `/app`
2. Commit and push changes
3. Vercel automatically redeploys

## Performance Optimization

### Image Optimization:
- Vercel automatically optimizes images via Next.js Image component
- Recommended: WebP format for WordPress images

### Caching Strategy:
- Static pages: Cached for 1 hour (ISR)
- WordPress API calls: Cached for 1 hour
- Clear cache by redeploying

### CDN:
- Vercel provides automatic CDN distribution
- Your site is served from edge servers worldwide

## Support & Resources

- **Vercel Docs:** https://vercel.com/docs
- **Next.js Docs:** https://nextjs.org/docs
- **WordPress REST API:** https://developer.wordpress.org/rest-api/
- **Troubleshooting:** Check deployment logs in Vercel dashboard

## Next Steps

1. Set up WordPress with the WORDPRESS_SETUP.md guide
2. Add your WordPress URL to Vercel environment variables
3. Deploy to Vercel
4. Verify all content loads correctly
5. Connect custom domain if desired
6. Start adding content to WordPress
